<?php

namespace App\Http\Requests\Admin\AppConfiguration;

use Illuminate\Foundation\Http\FormRequest;

class StoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

        /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'km_price' => "required",
            'moto_km_price' => "required",
            'start_fee' => "required",
            'waiting_price' => "required",
            'city_id' => "required|unique:app_configurations,city_id",
        ];
    }

    public function messages(): array {
        return [
            'city_id.unique'  => 'This city has configuration',
        ];
    }
}
