<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Carbon\Carbon;

class ReportResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return[
            // "user_id"=> $this->user_id,
            "date"=> $this->formatted_date,
            'day_name'=>Carbon::createFromFormat('Y-m-d', $this->formatted_date)->format('l'),
            "total_trips"=> $this->count,
            "total_time"=> (number_format((Integer)$this->sum_actual_time/60,0)).':'.$this->sum_actual_time%60,
            "grand_total"=> number_format($this->sum_start_fee +$this->sum_actual_price+$this->sum_total_waiting_time_fee,2),
        ];
    }

 
}
