<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class RidesResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return[
            "id" =>$this->id,
            "user" =>$this->user,
            "km_price" =>$this->km_fee,
            "waiting_price" =>$this->waiting_fee,
            "start_fee"=> $this->start_fee,
            "user_id"=> $this->user_id,
            "status"=> $this->status,
            "total_price"=> $this->total_price,
            "actual_price"=>number_format( (float)$this->actual_price+$this->start_fee+ $this->total_waiting_time_fee,2),
            "total_time"=> (Integer)($this->total_time/(60*60)),
            "actual_time"=> $this->actual_time,
            "total_distance"=> $this->total_distance,
            "actual_distance"=> number_format((float) $this->actual_distance,2),
            "total_distance_fee"=>number_format( ($this->start_fee*$this->km_price),2),
            // "total_waiting_time"=> $this->trasform($this->total_waiting_time),
            "total_waiting_time"=> (Integer)$this->total_waiting_time,
            "total_waiting_time_fee"=> $this->total_waiting_time_fee,
            "created_at"=> $this->created_at->format('Y-m-d h:i:s')
        ];
    }

    public function trasform($total_waiting_time)
    {
        $temp=0;
        if($total_waiting_time >0 && $total_waiting_time<=6)
            $temp=1;
        else if($total_waiting_time>6){
            $temp=(Integer)($total_waiting_time%6 ==0?$total_waiting_time/6:($total_waiting_time/6)+1); 
        }
        return $temp;
    }
}
