<?php

namespace App\Models;

use Carbon\Carbon;
use DateTimeInterface;
use App\Traits\FileUploadTrait;
use Laravel\Passport\HasApiTokens;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use SoftDeletes;
    use FileUploadTrait;
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */

     protected $guard="api";
    protected $fillable = 
    [
        'name', 'image',
        "active",
        'phone', 'password',
        'city_id' , 'device_id',
        'gender' ,'birth_date' ,
        'lang','lat' ,'model_year',
        "driving_license","car_license",
        'deleted_at',"subscription_start_date",
        "subscription_end_date" ,"subscription_number",
        "car_type_id","car_model_id",
        "car_color" , "vechile_type",
        'is_online','criminal_record',
        'blood_analysis'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = 
    [
        'password',
        // 'device_id',
        "deleted_at",
        'updated_at',
        'created_at',
    ];

    public function findForPassport(string $username): User
    {
        return $this->where('username', $username)->first();
    }

    public function setImageAttribute($value)
    {
        $this->attributes['image'] = $this->uploadFile($value,'profiles',$this->attributes['image'] ?? "");
    }

    public function setDrivingLicenseAttribute($value)
    {
        $this->attributes['driving_license'] = $this->uploadFile($value,'driving_license',$this->attributes['driving_license'] ?? "");
    }
    
    public function setBloodAnalysisAttribute($value)
    {
        $this->attributes['blood_analysis'] = $this->uploadFile($value,'blood_analysis',$this->attributes['blood_analysis'] ?? "");
    }
    
    public function setCriminalRecordAttribute($value)
    {
        $this->attributes['criminal_record'] = $this->uploadFile($value,'criminal_record',$this->attributes['criminal_record'] ?? "");
    }

    public function setCarLicenseAttribute($value)
    {
        $this->attributes['car_license'] = $this->uploadFile($value,'car_license',$this->attributes['car_license'] ?? "");
    }

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */

    protected $dates =[
        "birth_date",
        "subscription_start_date",
        "subscription_end_date"
    ];
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
    
    public function setPasswordAttribute($value){
        if(!is_null($value))
            $this->attributes['password'] = bcrypt($value);
    }

    // public function country(){
    //     return $this->belongsTo(Country::class);
    // }

    public function region(){
        return $this->belongsTo(City::class,'city_id');
    }
    
    public function carModel(){
        return $this->belongsTo(CarModel::class,'car_model_id');
    }
    public function carType(){
        return $this->belongsTo(CarType::class,'car_type_id');
    }
    


    // public function address(){
    //     return $this->hasMany(UserAdress::class);
    // }

    public function serializeDate($date)
    {
        return $date->format('Y-m-d'); // Format the date as desired
    }



}
