@extends('admin.layout.master')
@section('title', 'Basic DataTables')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/datatables.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/select2.css')}}">

@endsection

@section('style')
@endsection

@section('breadcrumb-title')
<h3> @lang('lang.AppConfiguration')</h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item"> @lang('lang.Dashboard')</li>
<li class="breadcrumb-item active"> @lang('lang.AppConfiguration')</li>
@endsection

@section('content')
<div class="container-fluid">
	{{-- @if($errors->any())
    {!! implode('', $errors->all('<span class="text text-danger">:message</span>')) !!}
@endif --}}
@error('city')

 <div class="alert alert-danger dark alert-dismissible fade show" role="alert"><strong>{{ $message }} </strong>
 <button class="btn-close" type="button" data-bs-dismiss="alert" aria-label="Close"></button>    </div>
							    @enderror
		<div class="row">
		<div class="col-sm-12 mt-3">
			<div class="card">
				<div class="card-body">
					<div class="table-responsive">
						<table class="display text-center" id="advance-1">
							<thead>
								<tr>
									<th>@lang('lang.city')</th>
									<th>@lang('lang.km_price')</th>
									<th>@lang('lang.moto_km_price')</th>
									<th>@lang('lang.start_fee')</th>
									<th>@lang('lang.waiting_price')</th>
									<th></th>									
								</tr>
							</thead>
							<tbody>
								@forelse ($result as $item)
									<tr>
										<td>
                                            {{$item->city->name }}
                                        </td>
										<td>
                                            {{$item->km_price }}
                                        </td>
										<td>
                                            {{$item->moto_km_price }}
                                        </td>
										<td>
                                            {{$item->start_fee }}
                                        </td>
					
										<td>{{ $item->waiting_price  }}</td>
																			
										<td>
											<button class="btn btn-primary" type="button" data-bs-toggle="modal" data-original-title="test" data-bs-target="#exampleModal"  onclick="getRecord({{ $item }})">@lang('lang.edit')</button>
                                                {{-- <form action="{{ route('city.destroy') }}" onclick="getId({{ $item->id }})" method="Post" id="form_id">
                                                @method("delete")
                                                @csrf
                                                <input type="hidden" name="id" id="notification_id">
                                                @can('delete notification')
                                                <button id="{{ $loop->iteration }}" class="btn btn-danger sweet-5" onclick="test()" type="button" >@lang('lang.remove')</button>
                                                @endcan	
                                            </form> --}}
										</td>
							
									</tr>
								@empty
									
								@endforelse
								
							</tbody>
							<tfoot>
								<tr>
									<th>@lang('lang.city')</th>
									<th>@lang('lang.km_price')</th>
									<th>@lang('lang.moto_km_price')</th>
									<th>@lang('lang.start_fee')</th>
									<th>@lang('lang.waiting_price')</th>
									<th></th>									
								</tr>							
							</tfoot>
						</table>
					</div>
				</div>
			</div>
		</div>
	
	</div>
</div>

<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">

	<div class="modal-dialog" role="document">
	   <div class="modal-content">
		  <div class="modal-header">
			 <h5 class="modal-title" id="exampleModalLabel">@lang('lang.edit')</h5>
			 <button class="btn-close" type="button" data-bs-dismiss="modal" aria-label="Close"></button>
		  </div>
		  <div class="modal-body">

			<form class="needs-validation" novalidate="" method="POST" enctype="multipart/form-data" action="{{ route('AppConfiguration.update') }}">
				@csrf
				<input type="hidden" id="section_id" name="id">
				<div class="row">
					<div class="col-md-12 mb-3">
						<label for="section_name">@lang('lang.km_price')</label>
						<input class="form-control" id="km_price" type="number" name="km_price" value="" placeholder="km_price" required="" step="0.01">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a name.</div>

					</div>
					<div class="col-md-12 mb-3">
						<label for="section_name">@lang('lang.moto_km_price')</label>
						<input class="form-control" id="moto_km_price" type="number" name="moto_km_price" value="" placeholder="moto_km_price" required="" step="0.01">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a name.</div>

					</div>
					<div class="col-md-12 mb-3">
						<label for="section_name">@lang('lang.start_fee')</label>
						<input class="form-control" id="start_fee" type="number" name="start_fee" value="" placeholder="start_fee" required="" step="0.01">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a name.</div>

					</div>

					<div class="col-md-12 mb-3">
						<label for="section_name">@lang('lang.waiting_price')</label>
						<input class="form-control" id="waiting_price" type="number" name="waiting_price" value="" placeholder="waiting_price" required="" step="0.01">
						<div class="valid-feedback">Looks good!</div>
						<div class="invalid-feedback">Please choose a name.</div>

					</div>
				
				</div>
				
				<div class="modal-footer">
					<button class="btn btn-primary" type="button" data-bs-dismiss="modal">@lang('lang.close')</button>
					<button class="btn btn-secondary" type="submit">@lang('lang.edit')</button>
				 </div>
			</form>

		  </div>
		  
	   </div>
	</div>
</div>

@endsection


@section('script')
<script src="{{asset('assets/js/datatable/datatables/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('assets/js/datatable/datatables/datatable.custom.js')}}"></script>
<script src="{{asset('assets/js/form-validation-custom.js')}}"></script>
<script src="{{asset('assets/js/select2/select2.full.min.js')}}"></script>
<script src="{{asset('assets/js/select2/select2-custom.js')}}"></script>
<script src="{{asset('assets/js/sweet-alert/sweetalert.min.js')}}"></script>
<script src="{{asset('assets/js/sweet-alert/app.js')}}"></script>

@endsection

<script>

	function getRecord(data){
	    document.getElementById("waiting_price").value=data['waiting_price'];
	    document.getElementById("start_fee").value=data['start_fee']; 
	    document.getElementById("km_price").value=data['km_price']; 
	    document.getElementById("moto_km_price").value=data['moto_km_price']; 
	    document.getElementById("section_id").value=data['id'];
   }
   
   function getId(id){
	    document.getElementById("notification_id").value=id;
   }
</script>