@extends('admin.layout.master')
@section('title', 'Validation Forms')

@section('css')
<link rel="stylesheet" type="text/css" href="{{asset('assets/css/vendors/select2.css')}}">

@endsection

@section('style')
@endsection

@section('breadcrumb-title')
<h3>@lang('lang.details')</h3>
@endsection

@section('breadcrumb-items')
<li class="breadcrumb-item">@lang('lang.Drivers')</li>
<li class="breadcrumb-item active">@lang('lang.details')</li>
@endsection

@section('content')
<div class="container-fluid">
	<div class="row">
		<div class="col-sm-12">
			<div class="card">
				<div class="card-body">
				
						<div class="row">
							<div class="col-md-6 mb-3">
								<label for="validationCustom01">@lang('lang.Name')</label>
								<input class="form-control" id="validationCustom01" type="text" name="name" value="{{ $user->name}}" disabled>
								<div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a name.</div>
							</div>
						
							<div class="col-md-6 mb-3">
								<label for="validationCustom02">@lang('lang.phone')</label>
								<input class="form-control" id="validationCustom02" type="text" name="phone"  value="{{ $user->phone}}" disabled>
								<div class="valid-feedback">Looks good!</div>
								@error('phone')
								    <div class="alert alert-danger">{{ $message }}</div>
							    @enderror
							</div>
                     

					
						</div>
						<div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="validationCustom01">@lang('lang.subscription_start_date')</label>
                                <input disabled class="form-control" id="validationCustom01" type="date"  value="{{ old('subscription_start_date', $user?->subscription_start_date?->format('Y-m-d'))??'' }}" >
                                <div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a date.</div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="validationCustom01">@lang('lang.subscription_end_date')</label>
                                <input disabled class="form-control" id="validationCustom01" type="date"  value="{{ old('subscription_end_date', $user->subscription_end_date?->format('Y-m-d')) }}" >
                                <div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a date.</div>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="validationCustom01">@lang('lang.status')</label>

                                <select disabled class="js-example-placeholder-multiple col-sm-12"  id="validationCustom01"  >
                                  
									<option value="1" @selected($user->active==1) >@lang('lang.active')</option>
									<option value="0" @selected($user->active==0) >@lang('lang.inactive')</option>

                              
                                </select>
                                <div class="invalid-feedback">Please provide a valid status.</div>

                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="validationCustom01">@lang('lang.birth_date')</label>
                                <input disabled class="form-control" id="validationCustom01" type="date"  value="{{ old('birth_date', $user->birth_date?->format('Y-m-d'))??'' }}" >
                                <div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a date.</div>
                            </div>
                            
                            <div class="col-md-6 mb-3">
								<label for="validationCustom01">@lang('lang.Name')</label>
								<input class="form-control" id="validationCustom01" type="text"  value="{{ $user->name}}" disabled>
								<div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a name.</div>
							</div>
							
							<div class="col-md-6 mb-3">
								<label for="validationCustom01">@lang('lang.car_color')</label>
								<input class="form-control" id="validationCustom01" type="text"  value="{{ $user->car_color}}" disabled>
								<div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a name.</div>
							</div>
							
							<div class="col-md-6 mb-3">
								<label for="validationCustom01">@lang('lang.region')</label>
								<input class="form-control" id="validationCustom01" type="text"  value="{{ $user->region->name}}" disabled>
								<div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a name.</div>
							</div>
							
							<div class="col-md-6 mb-3">
								<label for="validationCustom01">@lang('lang.model_year')</label>
								<input class="form-control" id="validationCustom01" type="text"  value="{{ $user->model_year}}" disabled>
								<div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a name.</div>
							</div>
							<div class="col-md-6 mb-3">
								<label for="validationCustom01">@lang('lang.carModel')</label>
								<input class="form-control" id="validationCustom01" type="text"  value="{{ $user->carModel->name}}" disabled>
								<div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a name.</div>
							</div>
							<div class="col-md-6 mb-3">
								<label for="validationCustom01">@lang('lang.carType')</label>
								<input class="form-control" id="validationCustom01" type="text" value="{{ $user->carType->name}}" disabled>
								<div class="valid-feedback">Looks good!</div>
                                <div class="invalid-feedback">Please choose a name.</div>
							</div>
							
                            
                            <div class="col-md-6 mb-3">
						
						        <a href="{{asset($user->car_license)}}" download rel="noopener noreferrer" 
						        target="_blank" class="btn btn-success"> @lang('lang.downloadFile_car_license')
                                </a>
							</div>
							
                            <div class="col-md-6 mb-3">
						
						        <a href="{{asset($user->image)}}" download rel="noopener noreferrer" 
						        target="_blank" class="btn btn-success"> @lang('lang.downloadFile_image')
                                </a>
							</div>
							
                            <div class="col-md-6 mb-3">
						
						        <a href="{{asset($user->driving_license)}}" download rel="noopener noreferrer" 
						        target="_blank" class="btn btn-success"> @lang('lang.downloadFile_driving_license')
                                </a>
							</div>
							
							  <div class="col-md-6 mb-3">
						
						        <a href="{{asset($user->blood_analysis)}}" download rel="noopener noreferrer" 
						        target="_blank" class="btn btn-success"> @lang('lang.blood_analysis')
                                </a>
							</div>
							
							  <div class="col-md-6 mb-3">
						
						        <a href="{{asset($user->criminal_record)}}" download rel="noopener noreferrer" 
						        target="_blank" class="btn btn-success"> @lang('lang.criminal_record')
                                </a>
							</div>
                        </div>

					

                      
						
				
				</div>
			</div>
			
		
		</div>
	</div>
</div>
@endsection

@section('script')
<script src="{{asset('assets/js/select2/select2.full.min.js')}}"></script>
<script src="{{asset('assets/js/select2/select2-custom.js')}}"></script>
<script src="{{asset('assets/js/form-validation-custom.js')}}"></script>
@endsection