<?php
namespace App\Http\Controllers;
use Illuminate\Support\Facades\Route;
Route::get('/n', function () {
    return "here now2";
})->name('/n');
//Country
Route::get('countries', [Api\CountriesController::class, 'index']);


Route::get('about_us', [Driver\AboutUsController::class, 'index']);
Route::middleware(['checkLanguage'])->group(function () {
    Route::post('check_client_exists', [Driver\Auth\UserAuthController::class, 'checkClientExists']);

    Route::get('cities', [Driver\CityController::class, 'cities']);
    // Route::get('regions', [Driver\CityController::class, 'regions']);
    Route::get('carModels', [Driver\CarModelController::class, 'index']);
    Route::get('carTypes', [Driver\CarTypeController::class, 'index']);

    // Route::post('send_otp_password', [Driver\Auth\UserAuthController::class, 'sendOtpPassword']);
    Route::post('send_otp_register', [Driver\Auth\UserAuthController::class, 'sendOtpRegister']);
    Route::post('reset_password', [Driver\Auth\ResetPasswordController::class, 'resetPassword']);
    
    Route::post('login', [Driver\Auth\UserAuthController::class, 'login']);
    Route::post('register', [Driver\Auth\UserAuthController::class, 'register']);




    //Banner
    Route::get('banners', [Driver\BannerController::class, 'index']);
    

    
Route::middleware(['auth:api','check_user_status'])->group(function () {

    //Rides
    Route::get('config', [Driver\RideController::class, 'config']);
    Route::post('reports', [Driver\RideController::class, 'reports']);
    Route::post('rides', [Driver\RideController::class, 'index']);
    Route::post('ride', [Driver\RideController::class, 'details']);
    Route::post('start-ride', [Driver\RideController::class, 'startRide']);
    Route::post('update-ride-info', [Driver\RideController::class, 'editRideLocation']);
    Route::post('finish-ride', [Driver\RideController::class, 'finishRide']);
    Route::post('inital-accept-ride', [Driver\RideController::class, 'initalAcceptRide']);
    
     Route::post('delivered-ride', [Driver\RideController::class, 'deliveredRide']);

    Route::post('contactUs', [Driver\ContactUsController::class, 'store']);


    Route::post('edit_password', [Driver\Auth\ResetPasswordController::class, 'editPassword']);

    Route::post('add_client_region', [Driver\CityController::class, 'addClientRegion']);
    Route::post('select_main_address', [Driver\CityController::class, 'updateMainAddress']);
    Route::post('edit_client_region', [Driver\CityController::class, 'editClientRegion']);
    Route::delete('delete_client_region', [Driver\CityController::class, 'deleteClientRegion']);

    //Discount
    Route::post('check_availabilty', [Driver\DiscountController::class, 'checkAvailabilty']);

    //Auth
    Route::get('logout', [Driver\Auth\UserAuthController::class, 'logout']);

    //Profile
    Route::get('profile', [Driver\ProfileController::class, 'index']);
    Route::delete('profile', [Driver\ProfileController::class, 'destroy']);
    Route::post('profile', [Driver\ProfileController::class, 'update']);
    Route::post('updateLang', [Driver\ProfileController::class, 'updateLang']);
    Route::post('updateLocation', [Driver\ProfileController::class, 'updateLocation']);
        Route::get('update-status', [Driver\ProfileController::class, 'updateStatus']);


});

});